#prelim commands to set up the enviroment.
restart:
with(LinearAlgebra):
with(Optimization):
interface(rtablesize = 25):
with(ArrayTools):
with(PolynomialTools):
with(DEtools):
with(DiscreteTransforms):
with(LinearAlgebra):
with(PolynomialTools):
with(SNAP):
read "../lib/approxore_functions.mpl":
read "../lib/OreGCRDviaOpt.mpl":
read "../lib/GCDviaOpt.mpl":
interface(rtablesize = 25):
R := [Dt, t]:
epsilon := 0.1e-4:


#compute the data we will use for this.

currentdir();
writeto("unbalanced_t_output.txt");
#kernelopts(printbytes=false);


max_deg:=5:
cofac_deg:=1:
h := [seq(add(randpoly(R[2], degree = ceil(2*(i)))*Dt^(j), j = 0 .. 1), i = 1 .. max_deg)]:
h:=[seq(evalf(h[i]/OreNorm(h[i],R,2)),i=1..nops(h))]:
fstar := [seq(RandDPolyUnormalized(ceil(i/2), 2 , R)-R[1]^(2), i = 2 .. max_deg+1)]:
gstar := [seq(RandDPolyUnormalized(ceil(i/2), 2, R)-R[1]^(2), i = 2 .. max_deg+1)]:

f:=[seq(evalf(mult(fstar[i], h[i], R)/OreNorm(mult(fstar[i], h[i], R), R, 2)), i = 1 .. max_deg)]:
g:=[seq(evalf(mult(gstar[i], h[i], R)/OreNorm(mult(gstar[i], h[i], R), R, 2)), i = 1 .. max_deg)]:

f_degrees:=[seq([degree(f[i],R[1]),degree(f[i],R[2])],i=1..nops(f))];
g_degrees:=[seq([degree(g[i],R[1]),degree(g[i],R[2])],i=1..nops(g))];
h_degrees:=[seq([degree(h[i],R[1]),degree(h[i],R[2])],i=1..nops(h))];


kernelopts(printbytes=false):
#Very Noisy,1e-2
f_noise_e2:=[seq(f[i]+Noise(f[i],1e-2,R),i=1..nops(f))]:
g_noise_e2:=[seq(g[i]+Noise(g[i],1e-2,R),i=1..nops(g))]:

#some noise, 1e-4
f_noise_e4:=[seq(f[i]+Noise(f[i],1e-4,R),i=1..nops(f))]:
g_noise_e4:=[seq(g[i]+Noise(g[i],1e-4,R),i=1..nops(g))]:

#minimal noise, 1e-8
f_noise_e8:=[seq(f[i]+Noise(f[i],1e-8,R),i=1..nops(f))]:
g_noise_e8:=[seq(g[i]+Noise(g[i],1e-8,R),i=1..nops(g))]:




#compute the GCRDs, via least squares. We pass the correct degree structure so the computations finish in less then a day...
computed_LS_GCRD:=[seq(ApproxGCRDViaLS(f[i], g[i], R, degree(h[i], R[1]), DegreeVector(h[i], R)), i = 1 .. nops(h))]:
computed_LS_GCRD_e2:=[seq(ApproxGCRDViaLS(f_noise_e2[i], g_noise_e2[i], R, degree(h[i], R[1]), DegreeVector(h[i], R)), i = 1 .. nops(h))]:
computed_LS_GCRD_e4:=[seq(ApproxGCRDViaLS(f_noise_e4[i], g_noise_e4[i], R, degree(h[i], R[1]), DegreeVector(h[i], R)), i = 1 .. nops(h))]:
computed_LS_GCRD_e8:=[seq(ApproxGCRDViaLS(f_noise_e8[i], g_noise_e8[i], R, degree(h[i], R[1]), DegreeVector(h[i], R)), i = 1 .. nops(h))]:

#now we normalize the computed GCRD
computed_LS_GCRD:=[seq(computed_LS_GCRD[i]/OreNorm(computed_LS_GCRD[i],R,2),i=1..nops(h))];
computed_LS_GCRD_e2:=[seq(computed_LS_GCRD_e2[i]/OreNorm(computed_LS_GCRD_e2[i],R,2),i=1..nops(h))];
computed_LS_GCRD_e4:=[seq(computed_LS_GCRD_e4[i]/OreNorm(computed_LS_GCRD_e4[i],R,2),i=1..nops(h))];
computed_LS_GCRD_e8:=[seq(computed_LS_GCRD_e8[i]/OreNorm(computed_LS_GCRD_e8[i],R,2),i=1..nops(h))];

#feed it acceptable test input, without any noise to save a considerable amount of time...
#computed_LS_GCRD:=h: 
#computed_LS_GCRD_e2:= h:
#computed_LS_GCRD_e4:=h:
#computed_LS_GCRD_e8:=h:



#compute the co-factors, by least squares division. 

computed_LS_fstar:=[seq(NumericRightDivisionViaLS(f[i], computed_LS_GCRD[i], R, [NumerDegreeVector(fstar[i], R), DenomDegreeVector(fstar[i], R)]), i = 1 .. nops(f))]:
computed_LS_gstar:=[seq(NumericRightDivisionViaLS(g[i], computed_LS_GCRD[i], R, [NumerDegreeVector(gstar[i], R), DenomDegreeVector(gstar[i], R)]), i = 1 .. nops(g))]:


computed_LS_fstar_e2:=[seq(NumericRightDivisionViaLS(f_noise_e2[i], computed_LS_GCRD_e2[i], R, [NumerDegreeVector(fstar[i], R), DenomDegreeVector(fstar[i], R)]), i = 1 .. nops(f))]:
computed_LS_gstar_e2:=[seq(NumericRightDivisionViaLS(g_noise_e2[i], computed_LS_GCRD_e2[i], R, [NumerDegreeVector(gstar[i], R), DenomDegreeVector(gstar[i], R)]), i = 1 .. nops(g))]:


computed_LS_fstar_e4:=[seq(NumericRightDivisionViaLS(f_noise_e4[i], computed_LS_GCRD_e4[i], R, [NumerDegreeVector(fstar[i], R), DenomDegreeVector(fstar[i], R)]), i = 1 .. nops(f))]:
computed_LS_gstar_e4:=[seq(NumericRightDivisionViaLS(g_noise_e4[i], computed_LS_GCRD_e4[i], R, [NumerDegreeVector(gstar[i], R), DenomDegreeVector(gstar[i], R)]), i = 1 .. nops(g))]:

computed_LS_fstar_e8:=[seq(NumericRightDivisionViaLS(f_noise_e8[i], computed_LS_GCRD_e8[i], R, [NumerDegreeVector(fstar[i], R), DenomDegreeVector(fstar[i], R)]), i = 1 .. nops(f))]:
computed_LS_gstar_e8:=[seq(NumericRightDivisionViaLS(g_noise_e8[i], computed_LS_GCRD_e8[i], R, [NumerDegreeVector(gstar[i], R), DenomDegreeVector(gstar[i], R)]), i = 1 .. nops(g))]:


#compute the initial guesses, without normalizing, yet.

initial_guess_f:=[seq(mult(computed_LS_fstar[i],computed_LS_GCRD[i],R),i=1..nops(computed_LS_fstar))]:
initial_guess_g:=[seq(mult(computed_LS_gstar[i],computed_LS_GCRD[i],R),i=1..nops(computed_LS_gstar))]:

initial_guess_f_e2:=[seq(mult(computed_LS_fstar_e2[i],computed_LS_GCRD_e2[i],R),i=1..nops(computed_LS_fstar_e2))]:
initial_guess_g_e2:=[seq(mult(computed_LS_gstar_e2[i],computed_LS_GCRD_e2[i],R),i=1..nops(computed_LS_gstar_e2))]:


initial_guess_f_e4:=[seq(mult(computed_LS_fstar_e4[i],computed_LS_GCRD_e4[i],R),i=1..nops(computed_LS_fstar_e4))]:
initial_guess_g_e4:=[seq(mult(computed_LS_gstar_e4[i],computed_LS_GCRD_e4[i],R),i=1..nops(computed_LS_gstar_e4))]:


initial_guess_f_e8:=[seq(mult(computed_LS_fstar_e8[i],computed_LS_GCRD_e8[i],R),i=1..nops(computed_LS_fstar_e8))]:
initial_guess_g_e8:=[seq(mult(computed_LS_gstar_e8[i],computed_LS_GCRD_e8[i],R),i=1..nops(computed_LS_gstar_e8))]:
kernelopts(printbytes=true):

#compute normalized errors
initial_error :=[seq( OreNorm(f[i]/OreNorm(f[i],R,2)-initial_guess_f[i]/OreNorm(initial_guess_f[i] ,R,2),R,2)^2 +OreNorm(g[i]/OreNorm(g[i],R,2)-initial_guess_g[i]/OreNorm(initial_guess_g[i] ,R,2),R,2)^2  ,i=1..nops(f))];
initial_error_e2:=[seq( OreNorm(f_noise_e2[i]/OreNorm(f_noise_e2[i],R,2)-initial_guess_f_e2[i]/OreNorm(initial_guess_f_e2[i],R,2),R,2)^2 +OreNorm(g_noise_e2[i]/OreNorm(g_noise_e2[i],R,2)-initial_guess_g_e2[i]/OreNorm(initial_guess_g_e2[i],R,2),R,2)^2  ,i=1..nops(f))];
initial_error_e4:=[seq( OreNorm(f_noise_e4[i]/OreNorm(f_noise_e4[i],R,2)-initial_guess_f_e4[i]/OreNorm(initial_guess_f_e4[i],R,2),R,2)^2 +OreNorm(g_noise_e4[i]/OreNorm(g_noise_e4[i],R,2)-initial_guess_g_e4[i]/OreNorm(initial_guess_g_e4[i],R,2),R,2)^2  ,i=1..nops(f))];
initial_error_e8:=[seq( OreNorm(f_noise_e8[i]/OreNorm(f_noise_e8[i],R,2)-initial_guess_f_e8[i]/OreNorm(initial_guess_f_e8[i],R,2),R,2)^2 +OreNorm(g_noise_e8[i]/OreNorm(g_noise_e8[i],R,2)-initial_guess_g_e8[i]/OreNorm(initial_guess_g_e8[i],R,2),R,2)^2  ,i=1..nops(f))];
kernelopts(printbytes=false):

#compute post-refinement newton iteration results, with 10 iterations. This is usually fast.
N:=10:
newton_refinement:=[seq(ApproximateGCRDviaNewton(f[i],g[i],computed_LS_GCRD[i],computed_LS_fstar[i],computed_LS_gstar[i],R,N)[4],i=1..nops(f))];
newton_refinement_e2:=[seq(ApproximateGCRDviaNewton(f_noise_e2[i],g_noise_e2[i],computed_LS_GCRD_e2[i],computed_LS_fstar_e2[i],computed_LS_gstar_e2[i],R,N)[4],i=1..nops(f))];
newton_refinement_e4:=[seq(ApproximateGCRDviaNewton(f_noise_e4[i],g_noise_e4[i],computed_LS_GCRD_e4[i],computed_LS_fstar_e4[i],computed_LS_gstar_e4[i],R,N)[4],i=1..nops(f))];
newton_refinement_e8:=[seq(ApproximateGCRDviaNewton(f_noise_e8[i],g_noise_e8[i],computed_LS_GCRD_e8[i],computed_LS_fstar_e8[i],computed_LS_gstar_e8[i],R,N)[4],i=1..nops(f))];
kernelopts(printbytes=true):



f_degrees:=[seq([degree(f[i],R[1]),degree(f[i],R[2])],i=1..nops(f))];
g_degrees:=[seq([degree(g[i],R[1]),degree(g[i],R[2])],i=1..nops(g))];
h_degrees:=[seq([degree(h[i],R[1]),degree(h[i],R[2])],i=1..nops(h))];
