#proc BasisPoly
#Input: Degree of basis Poly,  variable and indeterminant t
#Output: Polynomial with variable coeffs
#Purpose: Used for generating U/V with their undetermined coefficients.

BasisPoly := proc(deg,variable,t)
local myVector;
myVector := Vector(deg+1,i->variable[i-1]);
FromCoefficientVector(myVector,t);
end proc;


############################################################################
############################################################################
############################################################################


#Proc: GenerateEQs
#Input: U and V, polynomials with variable coeffs and two symbols (a,b) for the nullspace vector and
	the indeterminant in t.
#Output: Equations to pass to an optimizer.
#Purpose: GenerateEquations shorthand for optimization.

GenerateEQs := proc(U,V,a,b,t)
local avec, bvec, S,w;

S:=SylvesterMatrix(U,V,t);
avec:=Vector(degree(U,t),i->a[i-1]);
bvec:=Vector(degree(V,t),i->b[i-1]);
w:=ArrayTools:-Concatenate(1,avec,bvec);
EQs:=GenerateEquations(S,convert(w,list));
end proc;


############################################################################
############################################################################
############################################################################


#Proc: GenerateEQs
#Input: U and V, polynomials with variable coeffs and two symbols (a,b) for the nullspace vector and
	the indeterminant in t.
#Output: Equations to pass to an optimizer.
#Purpose: GenerateEquations shorthand for optimization.

###################################
######## NORM FUNCTIONS ###########
###  ASSUME ALL INPUT IS REAL  ####
###################################