###########################################################################
############## COMMUTATIVE APPROXIMATE GCD FUNCTIONS ######################
###########################################################################


#Version History

#0.0 - 	Initial prototype, skeleton, definitions

#1.0 - 	Optimization support for the two norm works. 1/infinity norm doesn't
#	seem to work with Maples optimizer. 

#1.1 -	Added de-vectorization of the solution.

##########################################################################
#proc BasisPoly
#Input: Degree of basis Poly,  variable and indeterminant t
#Output: Polynomial with variable coeffs
#Purpose: Used for generating U/V with their undetermined coefficients.

BasisPoly := proc(deg,variable,t)
  local myVector;
  myVector := Vector(deg+1,i->variable[i-1]);
  FromCoefficientVector(myVector,t);
end proc;


############################################################################
############################################################################
############################################################################


#Proc: GenerateEQs
#Input: U and V, polynomials with variable coeffs and two symbols (a,b) for the nullspace vector and
#	the indeterminant in t.
#Output: Equations to pass to an optimizer.
#Purpose: GenerateEquations shorthand for optimization.

GenerateEQs := proc(U,V,a,b,t)
  local avec, bvec, S,w,EQs;

  S:=SylvesterMatrix(U,V,t);
  avec:=Vector(degree(U,t),i->a[i-1]);
  bvec:=Vector(degree(V,t),i->b[i-1]);
  w:=ArrayTools:-Concatenate(1,avec,bvec);
  EQs:=GenerateEquations(S,convert(w,list));
end proc;


############################################################################
############################################################################
############################################################################


#Proc: ApproxOptGCD
#Input: polynomials f,g in indeterminant t with an appropriate norm function.
#	Presently 2 norm only. WIll adjust in later versions. 
#Output: Polynomials U and V in indeterminant t that correspond to our optimization problem
#	
#Purpose: Solve our GCD optimization problem

ApproxOptGCD := proc(f,g,t,norm)
local myNorm, NSV,m,n, objectiveFunction, objectiveVector ,U,V,EQs,S,sol;
  
  
  m:=degree(f,t);
  n:=degree(g,t);
  
  #using hard-coded u/v might be a bad idea if we used input pols as f/g.
  #I should protect it or something. 
  
  U:= BasisPoly(m,u,t);
  V:= BasisPoly(n,v,t);
  
  print(U);
  print(V);
  
  S:= SylvesterMatrix(U,V,t);
  
  print(S);
  
  myNorm:= FAIL;
  
  
  objectiveVector := Concatenate (1, CoefficientVector(f-U,t),CoefficientVector(g-V,t));
  

  
  NSV := Vector(n+m, i->a[i-1]); #generate the null space vector.
				#do it lazy with 1 var b/c we 
				# aren't interested in cofactors
				#right now
  
  print(NSV);
  
  
  #some place holder code is here for now.
    if norm = 1 then 
	myNorm := add(abs(NSV[i]),i=1..m+n)=1; #equation for 1 norm
	objectiveFunction:=add(abs(objectiveVector[i]),i=1..m+n+2);
    fi;

    if norm = 2 then 
      myNorm := add((NSV[i])^2,i=1..m+n)=1; #equation for 2 norm
      objectiveFunction:=add((objectiveVector[i]^2),i=1..m+n+2);
    fi;
    
    if norm = infinity then
      myNorm := max(abs( NSV)) =1; #equation for infinity/max norm
      objectiveFunction:=max(abs(objectiveVector));
    fi;
    

    EQs:=[op(GenerateEquations(S,convert(NSV,list))),myNorm];
    
    print(EQs);
    
    print(objectiveFunction);
    
    sol:=Minimize(objectiveFunction, [op(EQs),myNorm])[2][1+m+n..2*(m+n+1)];
    
    #1..m+1 corresponds to U
    U:=FromCoefficientVector(GenerateMatrix(sol[1..m+1], [seq(u[i], i = 0 .. m)])[2], x); 
    V:=FromCoefficientVector(GenerateMatrix(sol[m+2..m+n+2], [seq(v[i], i = 0 .. m)])[2], x); 
    
    return [U,V];
    
    #return [ myNorm, NSV,U,V,objectiveFunction];
end proc;

###################################
######## NORM FUNCTIONS ###########
###  ASSUME ALL INPUT IS REAL  ####
########### SERIOUSLY #############
###################################